/*
 * Generic configuration file for VMware Consolidated Backup (VCB).
 */

/*
 * Directory where all the VM backup jobs are supposed to reside in. 
 * For each backup job, a directory with a unique name derived from the
 * backup type and the VM name will be created here.
 * If omitted, BACKUPROOT defaults to c:\\mnt.
 * 
 * Make sure this directory exists before attempting any VM backups.
 */
// BACKUPROOT="C:\\mnt";


/*
 * URL that is used by "mountvm" to obtain the block list for a
 * disk image that is to be mounted on the backup proxy.
 *
 * Specifying this option is mandatory. There is no default
 * value.
 */
//HOST="bu02.eng.vmware.com";


/*
 * Port for communicating with all the VC SDK services.
 * Defaults to 443
 */
// PORT="443";

/*
 * Username/password used for authentication against the mountvm server.
 * VCB can be configured to use SSPI for authentication. The advantage 
 * of using SSPI is that it does not require the password to be stored
 * in this configuration file in plain text. In order to be able to use 
 * SSPI, the following conditions must be met:
 * 1) VCB must be configured to connect to a VirtualCenter Server 
 *    version 2.5 or newer and not to an ESX host directly. (i.e: "HOST" 
 *    must point to your VirtualCenter Server).
 * 2) VCB must always be used from a user context with the same username
 *    and password credentials on both the proxy machine and the 
 *    VirtualCenter Server or be a domain user. The backup application 
 *    service process which calls VCB must be configured to run under 
 *    this user context. VCB and the backup application that calls it 
 *    must not be used in the Local System account context. 
 * 3) The VCB user must have administrator privileges on the VCB proxy.
 * 4) The VCB user must be assigned to the "VCB Backup User" Role in 
 *    VirtualCenter.
 * If your setup meets all these conditions, you can enable SSPI 
 * authentication by setting USERNAME to "__sspi__". The value for the 
 * PASSWORD setting will be ignored in this case and hence can be set 
 * to "".
 *
 * As a third option, you can also specify the password using a Registry
 * key. The Virtual Machine Backup Guide has more information on this.
 *
 * Specifying a user name is mandatory. For SSPI, the password needs to be
 * set, but is ignored. When specifying the password in the Registry, do
 * not set the PASSWORD variable here, since this will override the 
 * Registry setting.
 */
//USERNAME="vcbUser";
//PASSWORD="XXX";


/*
 * TRANSPORT_MODE determines how VCB accesses virtual disk data. 
 * Currently, two modes are supported on Windows:
 *
 * +) "san"
 *    Virtual disk data is read directly off a shared storage device
 *    that that the virtual disk resides on. This requires VMFS
 *    storage on SAN or iSCSI and the storage device has to be
 *    accessible from both ESX and the VCB proxy.
 * +) "nbd"
 *    In this mode, VCB will use an over-the-network protocol to
 *    access the virtual disk. Data is read from the storage device by
 *    the ESX host and then sent across an unencrypted network channel
 *    to the VCB proxy.
 *    Please note that this mode does not provide the offload
 *    capabilities of the "san" mode (since data is still transferred
 *    from the ESX host across the network). However, "nbd" does not
 *    require shared storage and also enables VCB to be run inside a
 *    virtual machine.
 * +) "nbdssl"
 *    This mode is same as "nbd" except that the data transfered over
 *    the network is encrypted. The data transfer in "nbdssl" mode can 
 *    be slower and use more CPU than in the "nbd" transport mode. The 
 *    "nbdssl" mode will fail when connecting directly to ESX 3.0.x 
 *    or VC 2.0.x host.
 * +) "hotadd"
 *    This mode is available only when using VCB in a VM. It allows the
 *    data from the source VM to be backed up by hot adding its disks 
 *    to the backup VM. This gives the backup VM a very efficient data 
 *    access path to all the datastores accessible to the host running 
 *    the backing VM.
 *
 * The default option is "san".
 */
// TRANSPORT_MODE="san";

/*
 * The log level determines the amount of log output generated by VCB.
 * Valid ranges are from 0 (least verbose) to 6 (most verbose), with a
 * default setting of 3. Change this setting to 6 when troubleshooting.
 */
//LOGLEVEL=3;


/*
 * SNAPSHOT_POLICY determines how disk snapshots for backup are being created:
 * +) "automatic"
 *    A snapshot is being generated automatically by the Interoperability
 *    Module right before backup and it is being removed
 *    automatically right after backup.
 * +) "manual" - 
 *    Exactly one snapshot named "_VCB-BACKUP_" must already exist for
 *    each protected VM. The snapshot is mounted/unmounted on the proxy,
 *    but the snapshot is neither created nor deleted by VCB.
 *    This can be used to have external tools manage the backup snapshot.
 * +) "createonly"
 *    The Interoperability Module will create the snapshot for each VM
 *    right before it gets backed up, but will not remove the snapshot
 *    after unmounting.
 * +) "deleteonly"
 *    The Interoperability Module assumes that the snapshot named
 *    "_VCB-BACKUP_" has been created beforehand. The snapshot will be
 *    deleted automatically after backup.
 *
 * The default option is "automatic"
 *
 */
//SNAPSHOT_POLICY="automatic";



/*
 * The criteria to be used to identify a virtual machine
 *
 * +) ipaddr
 *    VMs are looked up based on their DNS name/IP address.
 * +) name
 *    VMs are looked up based on their name as shown in VirtualCenter.
 *    Note that backup will fail for VMs with non-unique names.
 *
 * The default option is "ipaddr". You should only change this
 * if you have multiple sets of VMs with the same IP address, but with
 * different names.
 */
//VM_LOOKUP_METHOD="ipaddr";


/*
 * Behavior for a backup job when the VM mount point already exists.
 * 
 * +) fail
 *    A pre-existing mountpoint is causing a backup job to fail
 * +) delete
 *    Attempt to remove the pre-existing mount point (and backup 
 *    snapshots associated with it). If this op. fails, fail
 *    the backup job.
 *
 * The default option is "fail"
 *
 * Note that when TRANSPORT_MODE is set to "hotadd", the value for
 * PREEXISTING_MOUNTPOINT and PREEXISTING_VCB_SNAPSHOT must be 
 * the same, since it is not possible to reliably remmove a pre-existing
 * snapshot in this case without cleaning up the mount point.
 */
//PREEXISTING_MOUNTPOINT="fail";



/*
 * Behavior for backup job when a previous backup snapshot of a virtual
 * machine already exists.
 *
 * +) fail
 *    A pre-existing backup snapshot is causing a backup job to fail
 * +) delete
 *    Attempt to delete the pre-existing backup snapshot. If the
 *    backup snapshot can be deleted without errors, proceed with
 *    the backup job. Otherwise fail the backup job.
 *
 * the default option is "fail"
 *
 * Note that when TRANSPORT_MODE is set to "hotadd", the value for
 * PREEXISTING_MOUNTPOINT and PREEXISTING_VCB_SNAPSHOT must be 
 * the same, since it is not possible to reliably remmove a pre-existing
 * snapshot in this case without cleaning up the mount point.
 */
//PREEXISTING_VCB_SNAPSHOT="fail";


/*
 * Number of times an operation is re-tried after it fails.
 * You might want to use this option if you see a large number
 * of backup jobs fail with "resource busy" errors. 
 *
 * Usually, backup software will retry failed jobs, but it
 * might be hours until the backup software retries.
 *
 * By default, retry is disabled (set to 0).
 */
//MAX_RETRIES=0;

/*
 * Number of seconds to wait before retrying a failed 
 * operation. The default value is 10 seconds.
 *
 * If you change this default, you probably also want to change
 * the default for MAX_RETRIES (since this setting only matters
 * if MAX_RETRIES is larger than 0).
 */
//BACKOFF_TIME=10;

